/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.TextIOBase;

public class UniversalIOWrapper
extends TextIOBase {
    private boolean skipNextLF = false;
    private EnumSet<Newline> newlineTypes = EnumSet.noneOf(Newline.class);

    public UniversalIOWrapper(BufferedIOBase bufferedIOBase) {
        super(bufferedIOBase);
    }

    public String read(int n) {
        int n2;
        if (n < 0) {
            return this.readall();
        }
        char[] cArray = new char[n];
        int n3 = 0;
        do {
            byte[] byArray = this.readahead.array();
            n2 = this.readahead.position();
            block5: while (n2 < this.readahead.limit() && n3 < n) {
                int n4 = byArray[n2++] & 0xFF;
                switch (n4) {
                    case 13: {
                        n4 = 10;
                        if (n2 == this.readahead.limit()) {
                            if (this.readChunk() == 0) {
                                this.newlineTypes.add(Newline.CR);
                                cArray[n3++] = n4;
                                return new String(cArray, 0, n3);
                            }
                            byArray = this.readahead.array();
                            n2 = this.readahead.position();
                        }
                        this.skipNextLF = true;
                        break;
                    }
                    case 10: {
                        if (this.skipNextLF) {
                            this.skipNextLF = false;
                            this.newlineTypes.add(Newline.CRLF);
                            continue block5;
                        }
                        this.newlineTypes.add(Newline.LF);
                        break;
                    }
                    default: {
                        if (!this.skipNextLF) break;
                        this.skipNextLF = false;
                        this.newlineTypes.add(Newline.CR);
                    }
                }
                cArray[n3++] = n4;
            }
        } while (n3 < n && this.readChunk(n - n3) > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(n2);
        }
        this.packReadahead();
        return new String(cArray, 0, n3);
    }

    public String readall() {
        ByteBuffer byteBuffer = this.bufferedIO.readall();
        char[] cArray = new char[this.readahead.remaining() + byteBuffer.remaining()];
        int n = this.readLoop(this.readahead.array(), this.readahead.position(), cArray, 0, this.readahead.remaining());
        this.readahead.position(this.readahead.limit());
        n += this.readLoop(byteBuffer.array(), byteBuffer.position(), cArray, n, byteBuffer.remaining());
        if (this.skipNextLF) {
            this.skipNextLF = false;
            this.newlineTypes.add(Newline.CR);
        }
        return new String(cArray, 0, n);
    }

    private int readLoop(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n3;
        block4: while (n < n5) {
            int n6 = byArray[n++] & 0xFF;
            switch (n6) {
                case 13: {
                    n6 = 10;
                    this.skipNextLF = true;
                    break;
                }
                case 10: {
                    if (this.skipNextLF) {
                        this.skipNextLF = false;
                        this.newlineTypes.add(Newline.CRLF);
                        continue block4;
                    }
                    this.newlineTypes.add(Newline.LF);
                    break;
                }
                default: {
                    if (!this.skipNextLF) break;
                    this.skipNextLF = false;
                    this.newlineTypes.add(Newline.CR);
                }
            }
            cArray[n2++] = n6;
        }
        return n2 - n4;
    }

    public String readline(int n) {
        int n2;
        do {
            byte[] byArray = this.readahead.array();
            n2 = this.readahead.position();
            int n3 = 0;
            block5: while (n2 < this.readahead.limit() && (n < 0 || this.builder.length() + n3 < n)) {
                int n4 = byArray[n2++] & 0xFF;
                switch (n4) {
                    case 13: {
                        n4 = 10;
                        if (n2 == this.readahead.limit()) {
                            if (this.readChunk() == 0) {
                                this.newlineTypes.add(Newline.CR);
                                this.interimBuilder[n3++] = n4;
                                this.builder.append(this.interimBuilder, 0, n3);
                                return this.drainBuilder();
                            }
                            n2 = this.readahead.position();
                        }
                        this.skipNextLF = true;
                        this.interimBuilder[n3++] = n4;
                        this.builder.append(this.interimBuilder, 0, n3);
                        this.readahead.position(n2);
                        return this.drainBuilder();
                    }
                    case 10: {
                        if (this.skipNextLF) {
                            this.skipNextLF = false;
                            this.newlineTypes.add(Newline.CRLF);
                            continue block5;
                        }
                        this.newlineTypes.add(Newline.LF);
                        this.interimBuilder[n3++] = n4;
                        this.builder.append(this.interimBuilder, 0, n3);
                        this.readahead.position(n2);
                        return this.drainBuilder();
                    }
                }
                if (this.skipNextLF) {
                    this.skipNextLF = false;
                    this.newlineTypes.add(Newline.CR);
                }
                this.interimBuilder[n3++] = n4;
            }
            this.builder.append(this.interimBuilder, 0, n3);
        } while ((n < 0 || this.builder.length() < n) && this.readChunk() > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(n2);
        }
        return this.drainBuilder();
    }

    public int write(String string) {
        this.checkClosed();
        this.checkWritable();
        return -1;
    }

    public long seek(long l, int n) {
        l = super.seek(l, n);
        this.skipNextLF = false;
        return l;
    }

    public long tell() {
        int n;
        long l = super.tell();
        if (this.skipNextLF && !this.atEOF() && this.readahead.get(n = this.readahead.position()) == 10) {
            this.skipNextLF = false;
            this.newlineTypes.add(Newline.CRLF);
            this.readahead.position(++n);
            ++l;
        }
        return l;
    }

    public PyObject getNewlines() {
        int n = this.newlineTypes.size();
        if (n == 0) {
            return Py.None;
        }
        if (n == 1) {
            Newline newline = (Newline)((Object)this.newlineTypes.iterator().next());
            return new PyString(newline.getValue());
        }
        PyObject[] pyObjectArray = new PyObject[n];
        int n2 = 0;
        for (Newline newline : this.newlineTypes) {
            pyObjectArray[n2++] = new PyString(newline.getValue());
        }
        return new PyTuple(pyObjectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Newline {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private Newline(String string2) {
            this.value = string2;
        }
    }
}

